from typing import Any
from time import sleep

import allure
import requests
from jsonpath import jsonpath
from requests import Response
from selenium.webdriver import ActionChains
from selenium.webdriver.remote.webdriver import WebDriver
from selenium.webdriver.remote.webelement import WebElement


class Session(object):
    __MAP__: dict[str, Any] = {}
    __INSTANCE__ = None

    @classmethod
    def session(cls, name='instance', init_params=None):
        if name not in cls.__MAP__:
            cls.__MAP__[name] = cls()
        cls.__INSTANCE__ = cls.__MAP__[name]


class Time(Session):

    @classmethod
    def sleep(cls, seconds):
        with allure.step(f"等待{seconds}s"):
            sleep(int(seconds))


class HTTP(Session):
    response: Response = None

    @classmethod
    def get(cls, url, params=None):
        with allure.step(f"发送get请求: url={url}"):
            with allure.step(f"请求参数为: params={params}"):
                cls.response = requests.get(url, params=params)
            return cls.response

    @classmethod
    def post(cls, url, json):
        with allure.step(f"发送post请求: url={url}"):
            with allure.step(f"请求数据为: json={json}"):
                cls.response = requests.post(url, json=json)
            return cls.response

    @classmethod
    def assert_status_code(cls, value):
        with allure.step(f"断言状态码为: {value}"):
            assert str(cls.response.status_code) == str(value)

    @classmethod
    def json(cls):
        with allure.step(f"获取json"):
            return cls.response.json()

    @classmethod
    def text(cls):
        with allure.step(f"获取text"):
            return cls.response.text

    @classmethod
    def status_code(cls):
        with allure.step(f"获取状态码"):
            return cls.response.status_code

    @classmethod
    def headers(cls):
        with allure.step(f"获取headers"):
            return cls.response.headers

    @classmethod
    def assert_json_path(cls, path, value):
        with allure.step(f"断言jsonpath: {path}={value}"):
            assert jsonpath(cls.json(), path) == value


class Selenium(Session):
    driver: WebDriver = None
    element: WebElement = None

    @classmethod
    def chrome(cls):
        from selenium import webdriver
        options = webdriver.ChromeOptions()
        options.add_argument("--disable-extensions")
        options.add_argument("--disable-gpu")
        options.add_argument("--no-sandbox")
        options.add_argument("--headless")
        cls.driver = webdriver.Chrome(options=options)

    @classmethod
    def get(cls, url):
        with allure.step(f"浏览器输入: url={url}"):
            cls.driver.get(url)

    @classmethod
    def click(cls):
        with allure.step(f"点击"):
            with allure.step("点击前页面"):
                cls.save_screenshot()
            cls.element.click()
            with allure.step("点击后页面"):
                cls.save_screenshot()

    @classmethod
    def send_keys(cls, value):
        with allure.step(f"输入: {value}"):
            cls.element.send_keys(value)

    @classmethod
    def find_element(cls, by, value):
        with allure.step(f"查找元素: {by}={value}"):
            r = cls.driver.find_element(by, value)
            cls.element = r
        with allure.step(f"保存图片"):
            cls.save_screenshot()

    @classmethod
    def save_screenshot(cls):
        sleep(0.5)
        cls.driver.save_screenshot("screenshot.png")
        allure.attach.file("screenshot.png", attachment_type=allure.attachment_type.PNG)

    @classmethod
    def get_title(cls):
        with allure.step(f"获取浏览器标题"):
            return cls.driver.title

    @classmethod
    def quit(cls):
        with allure.step(f"退出浏览器"):
            cls.driver.quit()

    @classmethod
    def execute_script(cls, script, *args):
        with allure.step(f"执行JavaScript: {script}"):
            return cls.driver.execute_script(script, *args)

    @classmethod
    def move_to_element(cls, by, value):
        with allure.step("移动到元素"):
            element = cls.driver.find_element(by, value)
            actions = ActionChains(cls.driver)
            actions.move_to_element(element).perform()
            cls.save_screenshot()

    @classmethod
    def get_attribute(cls, attribute=''):
        with allure.step(f"获取元素属性: {attribute}"):
            if not attribute:
                value = cls.element.text
            else:
                value = cls.element.get_attribute(attribute)
            with allure.step(f"属性值: {value}"):
                return value

    @classmethod
    def get_property(cls, name):
        with allure.step(f"获取元素属性: {name}"):
            value = cls.element.get_property(name)
            with allure.step(f"属性值: {value}"):
                return value

    @classmethod
    def refresh(cls):
        with allure.step("刷新页面"):
            cls.driver.refresh()

    @classmethod
    def clear(cls):
        with allure.step("清空输入框"):
            cls.element.clear()


class Web(Session):
    @classmethod
    def 启动谷歌浏览器(cls):
        Selenium.chrome()

    @classmethod
    def 打开网址(cls, url):
        Selenium.get(url)

    @classmethod
    def 点击(cls):
        Selenium.click()

    @classmethod
    def 输入(cls, value):
        Selenium.send_keys(value)

    @classmethod
    def 查找元素(cls, by, value):
        Selenium.find_element(by, value)

    @classmethod
    def 获取页面标题(cls):
        return Selenium.get_title()

    @classmethod
    def 关闭浏览器(cls):
        Selenium.quit()

    @classmethod
    def 执行脚本(cls, script, *args):
        return Selenium.execute_script(script, *args)

    @classmethod
    def 移动到元素(cls, by, value):
        Selenium.move_to_element(by, value)

    @classmethod
    def 获取静态元素属性(cls, attribute=''):
        return Selenium.get_attribute(attribute)

    @classmethod
    def 获取动态元素属性(cls, name):
        return Selenium.get_property(name)

    @classmethod
    def 刷新(cls):
        Selenium.refresh()

    @classmethod
    def 清空输入框(cls):
        Selenium.clear()


class FAZMzx1P(Session):

    @classmethod
    def fetch_title(cls):
        Selenium.chrome()
        Selenium.get(url="https://www.baidu.com/")
        title = Selenium.get_title()
        assert "百度一下" in title
        


class TestFAZMzx1P:

    def setup_class(self):
        pass

    def setup_method(self):
        Time.session()
        HTTP.session()
        Selenium.session()
        FAZMzx1P.session()
        
    def test_search(self):
        FAZMzx1P.fetch_title()
        
    def teardown_method(self):
        pass

    def teardown_class(self):
        pass
